//

// Fragment shader for sepia effect
//
// Author: Shirley Carter
//
// invert like a B&W negative
uniform sampler2DRect texUnit;
uniform  vec4 modulateColor;
uniform vec4 textureRect;

varying vec2 gUV;

void main(void)
{
	if ( gUV.x< textureRect.x || gUV.x> textureRect.x+textureRect.z || gUV.y < textureRect.y || gUV.y > textureRect.y+textureRect.w )
        gl_FragColor = vec4(0.0,0.0,0.0,0.0);
    else {
        vec4 texel = texture2DRect(texUnit, gUV);

        // Convert to grayscale
        float gray = dot(texel.rgb, vec3(0.299, 0.587, 0.114));

        // invert
        gray = 1.0 - gray;

        // replicate grayscale to RGB components
        gl_FragColor =  modulateColor * vec4(gray, gray, gray,texel.a);
    }
}

